function D = get_gradient_gmm_competitive(param, N_variables, N_ll)
% This function numerically computes the gradient of model moments with
% respect to the structural parameters. 

M = (N_variables+1)*N_variables/2 + N_variables * N_ll ; % Number of moments
T = 17; % Total parameters
N = 5; % Estimated parameters

D = nan(M, N);
I = eye(T);

estimated = [13:17];

h = min(abs(param/1.2), 0.2*10^(-5));


for j = estimated
    
    moments_u = Model_Moments_competitive(param + I(j, :) * h(j), N_variables, N_ll);
    moments_d = Model_Moments_competitive(param - I(j, :) * h(j), N_variables, N_ll);
    ind = j==estimated;
    D(:, ind) = (moments_u - moments_d)/(2*h(j));
    
    
end

D = D';


